\version "2.24.0"

\paper {
  %system-system-spacing = 0\mm
  system-system-padding = 5\mm
  markup-system-spacing = #'((basic-distance . 2))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  bottom-margin = 3\mm
  top-margin = 5\mm
  ragged-last-bottom=##f
  system-count = #5
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Cerul şi pământul"
  %subtitle = "Nr. 1"
  composer = "pr. Vasile Stanciu" 
  meter = "Adagio"
  tagline=""
}

global = {
  \key aes \major
  %\autoBeamOff
  %\cadenzaOn
  %\time 4/8
  \set Staff.midiInstrument = "clarinet"
}

womenWords = \lyricmode {
  \set stanza = "1."
  \set ignoreMelismata = ##t
  Ce -- rul \unset ignoreMelismata
  şi pă -- mân -- tul,
  \set ignoreMelismata = ##t
  Ce -- rul \unset ignoreMelismata
  şi pă -- mân -- tul
  În __ cân -- tări ră -- su -- nă,
  În -- geri şi oa -- meni,
  În -- geri şi oa -- meni
  Cân -- tă îm -- pre -- u -- nă.
  
  Hris -- tos se naş -- te,
  Dom -- nul co -- boa -- ră,
  În -- ge -- rii cân -- tă,
  Ma -- gii îl a -- do -- ră,
  Păs -- to -- rii-a -- lear -- gă,
  Ies -- lea o-n -- con -- joa -- ră,
  Mari mi -- nuni se în -- tâm -- pla -- ră.
  
  Hris -- tos se naş -- te!
}

womenWordsTwo = \lyricmode {
  \set stanza = "2."
  Din cer cu -- vân -- tul,
  Din cer cu -- vân -- tul
  În __ trup se a -- ra -- tă,
  Noap -- tea din lu -- me,
  Noap -- tea din lu -- me
  Zi se fa -- ce-n -- da -- tă.
}

womenWordsThree = \lyricmode {
  \set stanza = "3."
  Hris -- tos se naş -- te,
  Hris -- tos se naş -- te
  \set ignoreMelismata = ##t
  Ve -- niţi \unset ignoreMelismata
  la în -- chi -- na -- re
  Cu ve -- sel su -- flet, 
  Cu ve -- sel su -- flet 
  \set ignoreMelismata = ##t
  Cu ve -- \unset ignoreMelismata
  se -- lă cân -- ta -- re.
}

menWords = \lyricmode {
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 
  Hris -- tos se naş -- te,
  Dom -- nul co -- boa -- ră,
  În -- ge -- rii cân -- tă,
  Ma -- gii îl a -- do -- ră,
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 
  Hris -- tos se naş -- te!
}


sopMusic = \relative c'' {
  \compoundMeter #'((4 8) (2 8))
  \slurDashed
  aes8([ aes]) aes ees \bar "|"
  aes bes \bar "|"
  c8([ c]) c bes \bar "|"
  c des \bar "|"
  ees4( f8) ees \bar "|"
  des c \bar "|"
  bes4 aes \bar "|"
  
  \slurSolid
  aes8([ aes]) aes ees \bar "|"
  aes bes \bar "|"
  c8([ c]) c bes \bar "|"
  c des \bar "|"
  \slurDashed
  ees4( f8) ees \bar "|"
  \slurSolid
  des c \bar "|"
  bes4 aes \bar "||"

  \mark "Refr."
  f'4 f8 f \bar "|"
  ees([ f ees]) des \bar "|"
  c4 c8 c \bar "|"
  c4 bes \bar "|"

  bes4 bes8 bes \bar "|"
  ees8([ des c]) bes  \bar "|"
  aes aes g f  \bar "|"
  f4 ees  \bar "|"

  aes4 aes8 ees  \bar "|"
  aes bes  \bar "|"
  c c c bes  \bar "|"
  c des  \bar "|"

  ees ees f ees  \bar "|"
  des c  \bar "|"
  bes4 aes  \bar ":|."

  \mark "Coda"
  aes8([ bes]) c aes  \bar "|"
  bes([ c] des[ ees]) \bar "|"
  c2 \fermata \bar "|."
}

altMusic = \relative c'' {
  \slurDashed
  aes8([ aes]) aes ees
  aes bes
  c8([ c]) c bes
  aes bes
  c4( des8) c
  bes aes
  g4 aes
  
  \slurSolid
  aes8([ aes]) aes ees
  aes bes
  c8([ c]) c bes
  aes bes
  \slurDashed
  c4( des8) c
  bes aes
  g4 aes
  
  \slurSolid
  des4 des8 des
  c8([ des c]) aes
  aes4 aes8 aes
  aes4 g
  
  g4 g8 g
  c([ bes aes]) g
  aes aes g f
  f4 ees

  aes4 aes8 ees
  c ees
  aes aes aes g
  aes bes
  c c des c
  bes aes
  g4 aes
  
  aes8([ bes]) c aes
  ees4( aes8[ g])
  aes2
}  

tenorMusic = \relative c {
  \slurDashed
  d2\rest d4\rest
  aes'8([ aes]) aes g
  aes aes
  aes4( aes8) aes
  g aes
  \slurSolid
  ees([ des]) c4
  
  d2\rest d4\rest
  aes'8([ aes]) aes g
  aes aes
  \slurDashed
  aes4( aes8) aes
  g aes
  ees4 aes
  
  d,2\rest
  aes'4 aes8 aes
  ees4 ees
  aes4 ees8 ees
  
  \slurSolid
  ees4 ees
  ees ees8 ees
  f4 ees8([ f16 g])
  aes8 aes g g
  
  ees4 c
  b4\rest
  ees8 ees ees ees
  aes16([ g]) f([ ees])
  
  aes8 aes aes aes
  g aes
  ees([ des]) c4
  
  b2\rest
  aes'8([ g]) f  ees
  aes4 aes
}

bassMusic = \relative c {
  \compoundMeter #'((4 8) (2 8))
  \slurDashed
  d2\rest d4\rest
  aes'8([ aes]) aes g
  aes aes
  aes4( aes8) aes
  ees ees
  ees4 aes,
  
  \slurSolid
  d2\rest d4\rest
  aes'8([ aes]) aes g
  aes aes
  \slurDashed
  aes4( aes8) aes
  ees ees
  ees4 aes
  \slurSolid
  
  d,2\rest
  aes'8([ des,]) ees f
  ees([ aes,]) c([ ees])
  aes4 ees8 ees
  
  ees,4 ees  
  aes8([ bes]) c16([ des]) ees8 
  f4 ees8([ des]) 
  des des ees ees16([ des]) 

  c4 aes
  b4\rest 
  aes8 aes c ees 
  aes16([ g]) f([ ees]) 

  aes16([ g]) f([ ees]) des8 ees16([ f])
  ees8 ees 
  ees([ des]) aes4

  b2\rest
  aes'8([ g]) f  ees
  aes4 aes
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      \new Voice { \global \voiceOne \sopMusic }
      \new Voice { \global \voiceTwo \altMusic }
      \addlyrics { \womenWords }
      \addlyrics { \womenWordsTwo }
      \addlyrics { \womenWordsThree }
    >>
    \new Staff <<
      \clef bass
      \new Voice { \global \voiceOne \tenorMusic }
      \new Voice { \global \voiceTwo \bassMusic }
      \addlyrics { \menWords }
    >>
    >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
  \tempo 4 = 40
  \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}
